--print("[AEP] Lade register.lua ...")

local cfgManager = g_vehicleConfigurationManager
local vtm        = g_vehicleTypeManager
local sm         = g_specializationManager

local SPEC_NAME = "adjustEnginePower"
local MOD_DIR   = g_currentModDirectory

-----------------------------------------------------------------------
-- 1) Spezialisierung REGISTRIEREN
-----------------------------------------------------------------------
if sm:getSpecializationByName(SPEC_NAME) == nil then
    sm:addSpecialization(
        SPEC_NAME,
        SPEC_NAME,
        Utils.getFilename("AdjustEnginePower.lua", MOD_DIR),
        nil
    )
    --print("[AEP] Spezialisierung registriert:", SPEC_NAME)
end

-----------------------------------------------------------------------
-- 2) Shop-Konfiguration registrieren
-----------------------------------------------------------------------
if cfgManager.configurations["adjustEnginePower"] == nil then
    cfgManager:addConfigurationType(
        "adjustEnginePower",
        g_i18n:getText("configuration_adjustEnginePower"),
        "vehicle.adjustEnginePower",
        VehicleConfigurationItem
    )
end

--print("[AEP] Shop-Konfiguration registriert.")

-----------------------------------------------------------------------
-- 3) Boost-Einträge in Fahrzeuge einfügen (Konfig-Liste aus boostConfigurations.xml)
-----------------------------------------------------------------------
local function addAdjustEnginePowerConfig(manager, superFunc, xmlFile, key, baseDir, customEnv, isMod, storeItem)
    local configs, defaultConfigIds =
        superFunc(manager, xmlFile, key, baseDir, customEnv, isMod, storeItem)

    if storeItem == nil then
        return configs, defaultConfigIds
    end

    -- Nur Motorfahrzeuge (Shop-Typen)
    local t = xmlFile:getValue(key .. "#type")
    local allowed = { tractor=true, carFillableCameraMirrors=true, tractorForestry=true, carFillable=true, car=true, tractorReverseDriving=true, woodTruck=true, hookLiftTruck=true, tractorHookLiftTrailer=true, teleHandler=true, carConditionalObjectChanges=true, tractorCameraMirrors=true }
    if not allowed[t] then
        return configs, defaultConfigIds
    end

    configs = configs or {}
    configs.adjustEnginePower = {}

    local path = Utils.getFilename("boostConfigurations.xml", MOD_DIR)
    local boostXML = loadXMLFile("boostCfg", path)
    if boostXML == 0 then
        print("[AEP] boostConfigurations.xml NICHT gefunden!")
        return configs, defaultConfigIds
    end

    local i = 0
    while true do
        local k = ("boostConfigurations.boost(%d)"):format(i)
        if not hasXMLProperty(boostXML, k) then break end

        local title = getXMLString(boostXML, k.."#title") or "Boost"
        local price = getXMLFloat(boostXML, k.."#price") or 0
        local boost = getXMLFloat(boostXML, k.."#boost") or 0

        local item = VehicleConfigurationItem.new("adjustEnginePower")
        item:setIndex(i+1)
        item.name      = title
        item.price     = price
        item.data      = { boost = boost }
        item.isDefault = (i == 0)

        configs.adjustEnginePower[i+1] = item

        i = i + 1
    end

    delete(boostXML)

    return configs, defaultConfigIds
end

ConfigurationUtil.getConfigurationsFromXML =
    Utils.overwrittenFunction(ConfigurationUtil.getConfigurationsFromXML, addAdjustEnginePowerConfig)

-----------------------------------------------------------------------
-- 4) Spezialisierung AN Fahrzeugtypen hängen
-----------------------------------------------------------------------
for typeName, vType in pairs(vtm.types) do
    if vType ~= nil and vType.specializations ~= nil then
        if  SpecializationUtil.hasSpecialization(Drivable,  vType.specializations)
        and SpecializationUtil.hasSpecialization(Motorized, vType.specializations)
        and not SpecializationUtil.hasSpecialization(Locomotive, vType.specializations)
        then
            if not SpecializationUtil.hasSpecialization(sm:getSpecializationByName(SPEC_NAME), vType.specializations) then
                vtm:addSpecialization(typeName, SPEC_NAME)
                --print("[AEP] Spezialisierung hinzugefügt zu Typ:", typeName)
            end
        end
    end
end

--print("[AEP] register.lua fertig.")
