AllRound_ExtensionSetGetEvent = {};
local AllRound_ExtensionSetGetEvent_mt = Class(AllRound_ExtensionSetGetEvent, Event)

InitEventClass(AllRound_ExtensionSetGetEvent, "AllRound_ExtensionSetGetEvent")

function AllRound_ExtensionSetGetEvent.emptyNew()
	local self =  Event.new(AllRound_ExtensionSetGetEvent_mt);
	self.className = "AllRound_ExtensionSetGetEvent";
	return self;
end;

function AllRound_ExtensionSetGetEvent.new(superStrength, uniqueUserId)
	local self = AllRound_ExtensionSetGetEvent.emptyNew();
	self.superStrength = superStrength or false;
	self.uniqueUserId = uniqueUserId;
	return self;
end;

function AllRound_ExtensionSetGetEvent:readStream(streamId, connection)
	if not connection:getIsServer() then
		local superStrength = streamReadBool(streamId);
		local uniqueUserId = streamReadString(streamId);

		local connectionPlayer = g_currentMission.playerSystem:getPlayerByConnection(connection);
		if connectionPlayer ~= nil then
			local targetPlayer = g_currentMission.playerSystem:getPlayerByUniqueId(uniqueUserId);
			for _, player in pairs(g_currentMission.playerSystem.players) do
				if targetPlayer.uniqueId == connectionPlayer.uniqueId then
					local currentlyActive = targetPlayer.hands.spec_hands.hasSuperStrength;
					if superStrength ~= currentlyActive then
						targetPlayer.hands:consoleCommandToggleSuperStrength();
						currentlyActive = targetPlayer.hands.spec_hands.hasSuperStrength;
						g_server:broadcastEvent(AllRound_ExtensionSetGetEvent.new(superStrength, uniqueUserId));
					end;
				end;
			end;
		end;
	end;
end;

function AllRound_ExtensionSetGetEvent:writeStream(streamId, connection)
	if connection:getIsServer() then
		streamWriteBool(streamId, self.superStrength);
		streamWriteString(streamId, self.uniqueUserId);
	end;
end;
