animalTrader = {}

local modDir = g_currentModDirectory
local animalTraderXmlFile = modDir.."animalTrader.xml"
local simpleHusbandries = modDir.."animalTraderSimpleHusbandries.i3d"
local animalLoadingTrigger = modDir.."animalLoadingTrigger.i3d"
local animalDealer = modDir.."animalDealer.i3d"
local animalTraderExist = false


function animalTrader:loadMap(savegame)	 
	PlaceableSystem.addPlaceable = Utils.appendedFunction(PlaceableSystem.addPlaceable,animalTrader.addPlaceable)		
end


function AIParameterLoadingStation:validate(fillTypeIndex, farmId)

    if self.loadingStationId == nil then
        return false, g_i18n:getText("ai_validationErrorNoLoadingStation")
    end

    local loadingStation = self:getLoadingStation()
    if loadingStation == nil then
        return false, g_i18n:getText("ai_validationErrorLoadingStationDoesNotExistAnymore")
    end

    if fillTypeIndex ~= nil then
        if not loadingStation:getIsFillTypeAISupported(fillTypeIndex) then
            return false, g_i18n:getText("ai_validationErrorFillTypeNotSupportedByLoadingStation")
        elseif loadingStation:getFillLevel(fillTypeIndex, farmId) <= 0 and loadingStation.owningPlaceable.spec_buyingStation == nil then
            return false, g_i18n:getText("ai_validationErrorLoadingStationIsEmpty")
        end
    end

    return true, nil
end


function animalTrader:addPlaceable(placeable)	

	local placeables = g_currentMission.placeableSystem.placeables

	if placeables ~= nil then
		for _, placeable in pairs(placeables) do		
			if placeable.configFileName == animalTraderXmlFile and placeable.spec_dynamicallyLoadedParts.parts ~= nil and not animalTraderExist then	
			
				SimpleHusbandry.MAX_NUM_ANIMALS = 2					
				
				for _, part in pairs(placeable.spec_dynamicallyLoadedParts.parts) do
					if part.filename ~= nil then
						if part.filename == simpleHusbandries then SimpleHusbandry:onCreate(part.node) end
						if part.filename == animalLoadingTrigger then AnimalLoadingTrigger:onCreate(part.node) end
						if part.filename == animalDealer then NPCSpot:onCreate(part.node) end
					end
				end	
				placeable.canBeSold = Utils.overwrittenFunction(placeable.canBeSold, animalTrader.canBeSold)														
--				placeable.isPreplaced = true
				animalTraderExist = true
--				table.insert(placeables, placeable)
--				placeable.uniqueId = "placeable595d952a260245eeea0cf4683fab84ff"
--				PlaceableSystem:addPlaceable(placeable)
			end	
		end
	end
end


function animalTrader:canBeSold()	
	return false, g_i18n:getText("remove")
end	

addModEventListener(animalTrader)