-- This file is part of FS25_Better_Animal_Waste_Products.
--
-- FS25_Better_Animal_Waste_Products is free software: you can redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- FS25_Better_Animal_Waste_Products is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
-- FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
-- details.
--
-- You should have received a copy of the GNU General Public License along with
-- FS25_Better_Animal_Waste_Products. If not, see <https://www.gnu.org/licenses/>.

BetterAnimalWasteProducts = {}

local function log(value)
    if value ~= nil then
        print("BetterAnimalWasteProducts: " .. value)
    else
        print("BetterAnimalWasteProducts: nil")
    end
end

local function log_dbg(...)
    if BetterAnimalWasteProducts.debugEnabled then
        log(...)
    end
end

local function log_dbg_verbose(...)
    if BetterAnimalWasteProducts.verboseDebugEnabled then
        log(...)
    end
end

function BetterAnimalWasteProducts:loadMapData(xmlFile, missionInfo, baseDirectory)
    log_dbg('BetterAnimalWasteProducts:loadMapData')

    if g_sprayTypeManager == nil then
        log_dbg("g_sprayTypeManager was nil")
        return
    end
    local solid_fertilizer_liters = g_sprayTypeManager:getSprayTypeByName("FERTILIZER")
    if solid_fertilizer_liters == nil or solid_fertilizer_liters.litersPerSecond == nil then
        log_dbg("Could not get solid_fertilizer_liters")
    end

    local array_of_strings = { "MANURE", "LIQUIDMANURE", "DIGESTATE" }
    for _, value in ipairs(array_of_strings) do
        local sprayType = g_sprayTypeManager:getSprayTypeByName(value)
        if sprayType ~= nil or sprayType.litersPerSecond ~= nil then
            local old_ratio = sprayType.litersPerSecond / solid_fertilizer_liters.litersPerSecond
            local max_sell_price = 1419               -- normal difficulty when manure was used
            local silo_cost = 570                     -- placeble silos
            local price_ratio = max_sell_price / silo_cost
            local new_ratio = old_ratio / price_ratio -- Will be 26.779422128

            -- The ratio, rather than a fixed value, was chosen so that in the case that
            -- any other mod or map changes this value, we have a fixed ratio based on the
            -- sell prices of the basegame.
            --
            -- By reducing the ration, it evens out at normal difficulty, and makes it better on hard,
            -- which makes it actually usable in the game.

            sprayType.litersPerSecond = solid_fertilizer_liters.litersPerSecond * new_ratio
        else
            log_dbg("Could not get sprayType for " .. value)
        end
    end
end

-- SprayTypeManager.loadMapData is the function responsible for loading sprayers, so we perform our changes after this
SprayTypeManager.loadMapData = Utils.appendedFunction(
    SprayTypeManager.loadMapData, BetterAnimalWasteProducts.loadMapData)

-- Do initialization if not already done - Ensured to only run once
if BetterAnimalWasteProducts.modActivated == nil then
    BetterAnimalWasteProducts.modActivated = true
    BetterAnimalWasteProducts.debugEnabled = false

    log_dbg("initialized")
end
