--
-- FastnightUI
-- V1.0.0.0
--
-- @author apuehri
-- @date 08/12/2024
--
-- Copyright (c) apuehri 
-- (Thanks to Farmsim Tim (timmeey86) for the inspiration, and code elements)
-- V1.0.0.0 ..... LS25 first implementation

fastnightUI = {};

local fastnightUI_mt = Class(fastnightUI)

function fastnightUI.new(settings, debug)
	local self = setmetatable({}, fastnightUI_mt);

	self.controls = {};
	self.settings = settings;
	self.timeScaling = {0;0.5;1;2;3;4;5;6;7;8;9;10;11;12;13;14;15;20;25;30;35;40;50;60;70;80;90;100;120;140;160;180;200;220;240;260;280;300;350;400;450;500;550;600;650;700;750;800;};
	self.hourSteps = {0;1;2;3;4;5;6;7;8;9;10;11;12;13;14;15;16;17;18;19;20;21;22;23;};
	self.minuteSteps = {0;10;20;30;40;50;};
	self.debug = debug;
	return self;
end

function fastnightUI:registerSettings()
	if self.debug then
		print("--- FastNight Debug ... fastnightUI:registerSettings");
	end;

	-- reference to the base game general settings page
	local settingsPage = g_gui.screenControllers[InGameMenu].pageSettings;

	-- define what we need in the settingspage
	local controlProperties = {
		{ name = "autoDayTimeScale", autoBind = true },
		{ name = "startDayHour", values = self.hourSteps, autoBind = true },
		{ name = "startDayMinute", values = self.minuteSteps, autoBind = true },
		{ name = "speedDay", values = self.timeScaling, autoBind = true },
		{ name = "autoNightTimeScale", autoBind = true },
		{ name = "startNightHour", values = self.hourSteps, autoBind = true },
		{ name = "startNightMinute", values = self.minuteSteps, autoBind = true },
		{ name = "speedNight", values = self.timeScaling, autoBind = true },
		{ name = "showHelp", autoBind = true }
	}
	UIHelper.createControlsDynamically(settingsPage, "fnui_setting_title", self, controlProperties, "fnui_");
	UIHelper.setupAutoBindControls(self, self.settings, fastnightUI.onSettingsChange);

	-- setinitial values
	self:updateUiElements();

	-- Trigger an update in order to enable/disable controls on settings frame open (disable controls when isAdmin=false)
	InGameMenuSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuSettingsFrame.onFrameOpen, function()
	 	self:updateUiElements(true); -- skip autobind controls
	end);

	-- Trigger to update the values when settings frame is closed
	InGameMenuSettingsFrame.onFrameClose = Utils.appendedFunction(InGameMenuSettingsFrame.onFrameClose, function()
		self:onFrameClose();
   	end);

	-- if self.debug then
	-- 	DebugUtil.printTableRecursively(self,"--- fastnightUI.registerSettings - ",0,1);
	-- end;
end;

function fastnightUI:onSettingsChange()
	if self.debug then
		print("--- FastNight Debug ... fastnightUI:onSettingsChange");
	end;	
	self:updateUiElements();
	-- fastnight:getSettingsFromUi();
end

function fastnightUI:updateUiElements(skipAutoBindControls)
	if not skipAutoBindControls then
		-- Note: This method is created dynamically by UIHelper.setupAutoBindControls
		self.populateAutoBindControls();
	end;

	--not everyone is allowed to do everything
	local isAdmin = g_currentMission:getIsServer() or g_currentMission.isMasterUser;
	if self.debug then
		print("--- FastNight Debug ... fastnightUI:updateUiElements isAdmin = " .. tostring(isAdmin));
	end;	
	for _, control in ipairs(self.controls) do
		control:setDisabled(not isAdmin);
	end;

	-- Update the focus manager
	local settingsPage = g_gui.screenControllers[InGameMenu].pageSettings;
	settingsPage.generalSettingsLayout:invalidateLayout();
end

function fastnightUI:onFrameClose()
	if self.debug then
		print("--- FastNight Debug ... fastnightUI:onFrameClose");
	end;
	fastnight:getSettingsFromUi();
end