--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 09.10.2022
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

PlaceableHusbandryMoveAnimals = {}

PlaceableHusbandryMoveAnimals.MOD_NAME = g_currentModName
PlaceableHusbandryMoveAnimals.SPEC_NAME = string.format("%s.husbandryMoveAnimals", g_currentModName)
PlaceableHusbandryMoveAnimals.SPEC_TABLE_NAME = string.format("spec_%s", PlaceableHusbandryMoveAnimals.SPEC_NAME)

function PlaceableHusbandryMoveAnimals.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(PlaceableHusbandryAnimals, specializations)
end

function PlaceableHusbandryMoveAnimals.registerEventListeners(placeableType)
    SpecializationUtil.registerEventListener(placeableType, "onPostLoad", PlaceableHusbandryMoveAnimals)
end

function PlaceableHusbandryMoveAnimals:onPostLoad(savegame)
    local husbandryAnimalsSpec = self.spec_husbandryAnimals
    local animalLoadingTrigger = husbandryAnimalsSpec.animalLoadingTrigger

    -- Replace activatable here to add new input binding without making unnecessary global changes to the 'AnimalLoadingTriggerActivatable' as it may be used by buildings not requiring this new feature.
    if animalLoadingTrigger ~= nil and animalLoadingTrigger.activatable ~= nil then
        if not animalLoadingTrigger.isDealer and animalLoadingTrigger.husbandry == self then
            g_currentMission.activatableObjectsSystem:removeActivatable(animalLoadingTrigger.activatable)

            animalLoadingTrigger.activatable = AnimalLoadingTriggerMoveActivatable.new(animalLoadingTrigger)
            self[PlaceableHusbandryMoveAnimals.SPEC_TABLE_NAME].activatableAdded = true
        end
    end
end


AnimalLoadingTriggerMoveActivatable = {}
AnimalLoadingTriggerMoveActivatable.MOD_NAME = g_currentModName

local AnimalLoadingTriggerMoveActivatable_mt = Class(AnimalLoadingTriggerMoveActivatable, AnimalLoadingTriggerActivatable)

function AnimalLoadingTriggerMoveActivatable.new(owningTrigger)
    local self = setmetatable({}, AnimalLoadingTriggerMoveActivatable_mt)

    self.owner = owningTrigger
    self.activateText = g_i18n:getText("animals_openAnimalScreen", owningTrigger.customEnvironment)

    self.activateActionEventId = nil
    self.moveAnimalsActionEventId = nil

    return self
end

function AnimalLoadingTriggerMoveActivatable:registerCustomInput(inputContext)
    local _, actionEventId = g_inputBinding:registerActionEvent(InputAction.ACTIVATE_OBJECT, self, self.actionEventActivate, false, true, false, true)

    g_inputBinding:setActionEventText(actionEventId, self.activateText)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, true)

    self.activateActionEventId = actionEventId

    if inputContext == PlayerInputComponent.INPUT_CONTEXT_NAME then
        _, actionEventId = g_inputBinding:registerActionEvent(InputAction.MOVE_HUSBANDRY_ANIMALS, self, self.actionEventMoveAnimals, false, true, false, true)

        g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_HIGH)
        g_inputBinding:setActionEventTextVisibility(actionEventId, true)

        self.moveAnimalsActionEventId = actionEventId
    end
end

function AnimalLoadingTriggerMoveActivatable:removeCustomInput(inputContext)
    g_inputBinding:removeActionEventsByTarget(self)

    self.activateActionEventId = nil
    self.moveAnimalsActionEventId = nil
end

function AnimalLoadingTriggerMoveActivatable:actionEventActivate(actionName, inputValue, callbackState, isAnalog)
    self:run()
end

function AnimalLoadingTriggerMoveActivatable:actionEventMoveAnimals(actionName, inputValue, callbackState, isAnalog)
    if self.owner == nil or self.owner.husbandry == nil or MoveAnimalsScreen == nil then
        InfoDialog.show(g_i18n:getText("warning_actionNotAllowedNow"))

        return
    end

    MoveAnimalsScreen.show(self.owner.husbandry)
end
