-- Mulch And Plow State Handler Script
-- Farming Simulator 25

Cultivator.processCultivatorArea = Utils.overwrittenFunction(Cultivator.processCultivatorArea, function(self, superFunc, workArea, dt)
	if not self.spec_cultivator.useDeepMode then
		local xs, _, zs = getWorldTranslation(workArea.start)
		local xw, _, zw = getWorldTranslation(workArea.width)
		local xh, _, zh = getWorldTranslation(workArea.height)

		-- Aplica status de triturado
		FSDensityMapUtil.updateMulcherArea(xs, zs, xw, zw, xh, zh)

		-- Remove aradura
		FSDensityMapUtil.updatePlowArea(xs, zs, xw, zw, xh, zh, false)
	end

	local realArea, area = superFunc(self, workArea, dt)
	return realArea, area
end)