VehicleFruitHud = {};
VehicleFruitHud.modDir = g_currentModDirectory;

VehicleFruitHud.metadata = {
	interface = "FS25 ...", --convert ls22 to ls25
	title = "VehicleFruit Hud",
	notes = "Setzt Verkaufspreis/Kapazität und ... zusätzlich ins VehicleFruit Hud",
	author = "(by HappyLooser)",
	version = "1.0.0.0",	
	build = 78,
	xmlVersion = 1,
	languageVersion = 1,
	datum = "20.11.2018",
	update = "03.03.2025",
	discord = "HappyLooser Modding",
	web = "",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

function VehicleFruitHud:loadMap(name)	
	print("---loading ".. tostring(VehicleFruitHud.metadata.title).. " ".. tostring(VehicleFruitHud.metadata.version).. "(#".. tostring(VehicleFruitHud.metadata.build).. ") ".. tostring(VehicleFruitHud.metadata.author).. "---")
	if not VehicleFruitHud:getDetiServer() then
		VehicleFruitHud:loadValues();		
	end;	
end;

function VehicleFruitHud:loadValues() --for All in Mod Extra Load
	if not VehicleFruitHud:getDetiServer() then		
		VehicleFruitHud.hlDebugMode = false;	--for Modder Testing				
		generateFolders();
		VehicleFruitHud.values = {fillLevelBox={}}; --global
		VehicleFruitHud.testString = {};
		VehicleFruitHud:loadSource(1);		
		VehicleFruitHud.loadError = false; --optional for !
		Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, VehicleFruitHud.onStartMission);		
	end;
end;

function VehicleFruitHud:onStartMission()	
	if VehicleFruitHud:getDetiServer() then return;end; 
	if g_currentMission.hlHudSystem ~= nil and g_currentMission.hlHudSystem.hlHud ~= nil and g_currentMission.hlHudSystem.hlHud.generate ~= nil then --check is HL Hud System ready !
		g_currentMission.hlUtils.modLoad("FS25_VehicleFruitHud");
		print("#Info: ".. tostring(VehicleFruitHud.metadata.title).. " generate GuiBox --> for HL Hud System (".. tostring(g_currentMission.hlHudSystem.metadata.version).. ")")
		VehicleFruitHud:loadSource(2);
		VehicleFruitHud_XmlGuiBox:loadGuiBox("VehicleFruitHud_GuiBox");
		if g_currentMission.hlHudSystem.hlGuiBox:getData("VehicleFruitHud_GuiBox") ~= nil then
			g_currentMission.hlUtils.loadLanguage( {modTitle=tostring(VehicleFruitHud.metadata.title), class="FS25_VehicleFruitHud", modDir=VehicleFruitHud.modDir.. "scripte_vfhud/", xmlDir="FS25_VehicleFruitHud", xmlVersion=VehicleFruitHud.metadata.languageVersion} );
			g_currentMission.hlUtils.addSwitchTimer( {name="vehicleFruitHud_switchTwo", delay=10, switch={[1]=30,[2]=5}} );
			vfSetGet:generateHorseHud();
			vfSetGet:loadFillLevelDisplay(true);
		else
			g_currentMission.hlUtils.modUnLoad("FS25_VehicleFruitHud");
			VehicleFruitHud.loadError = true; --optional for !			
			print("#WARNING: ".. tostring(VehicleFruitHud.metadata.title).. " CAN NOT GENERATE Box ! Check/Search: ? Mod cause with integrated HL Hud System ? ")
		end;
	else		
		VehicleFruitHud.loadError = true; --optional for !		
		print("#WARNING: ".. tostring(VehicleFruitHud.metadata.title).. " CAN NOT GENERATE Hud/Pda/Box ! MISSING --> HL Hud System ! Check/Search: ? Corrupt Mod with integrated HL Hud System ? ")
	end;
end;

function VehicleFruitHud:deleteMap()	
end;

function VehicleFruitHud:mouseEvent(posX, posY, isDown, isUp, button)	
end;

function VehicleFruitHud:keyEvent(unicode, sym, modifier, isDown)	
end;

function VehicleFruitHud:update(dt)	
end;

function VehicleFruitHud:draw(dt)	
	--if not VehicleFruitHud:getDetiServer() and not VehicleFruitHud.loadError then g_currentMission.hlHudSystem.clickAreas["VehicleFruitHud_OtherAreas"] = {};end; --reset click areas	
	if VehicleFruitHud:getDetiServer() or g_currentMission.hlUtils:getIngameMap() or g_currentMission.hlUtils:getFullSize(true,true) or VehicleFruitHud.loadError then return;end;
	--respect settings for other mods (not every mod) that's why
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods	
	if VehicleFruitHud.values ~= nil and VehicleFruitHud.values.guiMenu ~= nil and VehicleFruitHud.values.guiMenu.ownTable.view.horseHud[1] > 1 then
		local isControlled = g_currentMission.hlUtils.getControlledVehicle(true);		
		if isControlled ~= nil and isControlled.spec_rideable ~= nil then			
			VehicleFruitHud_Draw:setOpen(isControlled, vfSetGet:getSpeed(isControlled));			
		end;			
	end;
	if #VehicleFruitHud.testString > 0 then
		setTextBold(true);		
		for a=1, #VehicleFruitHud.testString do
			local posY = 0.25-(a/100);
			renderText(0.5, posY, 0.010, "-S ".. tostring(a).. "- ".. tostring(VehicleFruitHud.testString[a]));
		end;
	end;
	--respect settings for other mods
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
end;

function VehicleFruitHud:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function VehicleFruitHud:loadSource(int)
	if int == 1 then		
		source(VehicleFruitHud.modDir.."scripte_vfhud/vfSetGet.lua");				
	end;
	if int == 2 then		
		source(VehicleFruitHud.modDir.."scripte_vfhud/VehicleFruitHudGuiBoxSetGet.lua");		
		source(VehicleFruitHud.modDir.."scripte_vfhud/mouseKeyEvents/VehicleFruitHud_MouseKeyEventsGuiBox.lua");		
		source(VehicleFruitHud.modDir.."scripte_vfhud/xml/VehicleFruitHud_XmlGuiBox.lua");		
		source(VehicleFruitHud.modDir.."scripte_vfhud/mouseKeyEvents/VehicleFruitHud_MouseKeyEvents.lua");				
		source(VehicleFruitHud.modDir.."scripte_vfhud/draw/VehicleFruitHud_Draw.lua");		
	end;
end;

function generateFolders()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_VehicleFruitHud/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_VehicleFruitHud/languages/");	
end;
addModEventListener(VehicleFruitHud);