VehicleFruitHud_XmlGuiBox = {};

function VehicleFruitHud_XmlGuiBox:defaultValues(guiBox)
	guiBox.ownTable.view = {
		isOpen = {false,2};
		horseHud = {1,1,2};
		fillLevelExtras = {1,1,2}; --needs reconnect !
		capacity = {2,1,2};
		priceFolder = {2,1,2}; --open/close better for performance
		bestPrice = {2,1,2};
		priceTrend = {1,1,2};
		clickPrice = {2,1,2}; --view 4 best price stationes
		maxFillLevel = {1000,100,5000,100,1000}; --is,min,max,level,default (view first is filllevel max)
		sellingStationDistance = {2,1,2};
		sellingStationScaleTyp = {1,1,3}; --bulk,pallet,bale (prio)
	};	
	guiBox.ownTable.showColors = {
		isOpen = {false,2};
		price = "khaki";
		capacity = "white";	
	}
end;

function VehicleFruitHud_XmlGuiBox:onLoadXml(guiBox, Xml, xmlNameTag)
	if guiBox.ownTable.view == nil then VehicleFruitHud_XmlGuiBox:defaultValues(guiBox);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
						
		else
			return; --first config not found
		end;
		--view--
		local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
		for key, value in pairs (guiBox.ownTable.view) do
			if key ~= "isOpen" then
				if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then guiBox.ownTable.view[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;				
			end;
		end;
		--view--
		--show colors--
		--groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
		--for key, value in pairs (guiBox.ownTable.showColors) do
		--	if key ~= "isOpen" then
		--		if getXMLString(Xml, groupNameTag.."#".. tostring(key)) ~= nil then 
		--			local color = getXMLString(Xml, groupNameTag.."#".. tostring(key));
		--			if g_currentMission.hlUtils.colorIntern[color] ~= nil then guiBox.ownTable.showColors[key] = color;end;
		--		end;
		--	end;
		--end;
		--show colors--
	end;	
end;

function VehicleFruitHud_XmlGuiBox.onSaveXml(guiBox, Xml, xmlNameTag)
	setXMLInt(Xml, xmlNameTag.."#version", VehicleFruitHud.metadata.xmlVersion);
	--view--
	local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
	for key, value in pairs (guiBox.ownTable.view) do
		if key ~= "isOpen" then
			setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
		end;
	end;
	--view--
	--show colors--
	groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
	for key, value in pairs (guiBox.ownTable.showColors) do
		if key ~= "isOpen" then
			setXMLString(Xml, groupNameTag.."#".. tostring(key), value);
		end;
	end;
	--show colors--
end;

function VehicleFruitHud_XmlGuiBox:loadGuiBox(name)
	if name == "VehicleFruitHud_GuiBox" then
		VehicleFruitHud.values.guiMenu = g_currentMission.hlHudSystem.hlGuiBox.generate( {name="VehicleFruitHud_GuiBox", title="VehicleFruit Hud Settings",onOverGuiBoxHudSystem=true} );
		VehicleFruitHudGuiBoxSetGet:loadIcons(VehicleFruitHud.values.guiMenu);
		local linesSequence = {
			"fillLevelHudHeadline_","clickPrice_","sellingStationDistance_","fillLevelExtras_","capacity_","bestPrice_","priceTrend_","priceFolder_","maxFillLevel_",
			"horseHudHeadline_","horseHud_"
		};
				
		VehicleFruitHud.values.guiMenu.screen.canBounds.on = true;
		VehicleFruitHud.values.guiMenu.onClick = VehicleFruitHud_MouseKeyEventsGuiBox.onClickArea;
		VehicleFruitHud.values.guiMenu.onSaveXml = VehicleFruitHud_XmlGuiBox.onSaveXml;
		VehicleFruitHud_XmlGuiBox:onLoadXml(VehicleFruitHud.values.guiMenu, VehicleFruitHud.values.guiMenu:getXml()); --own guiBox load over Xml (replace Data)
		VehicleFruitHud.values.guiMenu.getLine = VehicleFruitHudGuiBoxSetGet.getLines;
		VehicleFruitHud.values.guiMenu.guiLines = {};
		for k,v in pairs(linesSequence) do
			table.insert(VehicleFruitHud.values.guiMenu.guiLines, v);
		end;		
		for l=1, #VehicleFruitHud.values.guiMenu.guiLines do
			VehicleFruitHud.values.guiMenu:addLine( {} );
		end;
		VehicleFruitHud.values.guiMenu:resetDimension();
		--GuiBox start over Hl Hud System		
	end;
end;